//
//  Inserting_a_Group_Entry_into_the_Address_BookAppDelegate.m
//  Inserting a Group Entry into the Address Book
//
//  Created by Vandad Nahavandipoor on 21/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Inserting_a_Group_Entry_into_the_Address_BookAppDelegate.h"

@implementation Inserting_a_Group_Entry_into_the_Address_BookAppDelegate

@synthesize window = _window;

- (ABRecordRef) newGroupWithName:(NSString *)paramGroupName
                   inAddressBook:(ABAddressBookRef)paramAddressBook{
  
  ABRecordRef result = NULL;
  
  if (paramAddressBook == NULL){
    NSLog(@"Książka adresowa ma wartość nil.");
    return NULL;
  }
  
  result = ABGroupCreate();
  
  if (result == NULL){
    NSLog(@"Nie udało się utworzyć nowej grupy.");
    return NULL;
  }
  
  BOOL couldSetGroupName = NO;
  CFErrorRef error = NULL;
  
  couldSetGroupName = ABRecordSetValue(result,
                                       kABGroupNameProperty,
                                       (__bridge CFTypeRef)paramGroupName,
                                       &error);
  
  if (couldSetGroupName){
    
    BOOL couldAddRecord = NO;
    CFErrorRef couldAddRecordError = NULL;
    
    couldAddRecord = ABAddressBookAddRecord(paramAddressBook, 
                                            result,
                                            &couldAddRecordError);
    
    if (couldAddRecord){
      
      NSLog(@"Udało się dodać nową grupę.");
      
      if (ABAddressBookHasUnsavedChanges(paramAddressBook)){
        BOOL couldSaveAddressBook = NO;
        CFErrorRef couldSaveAddressBookError = NULL;
        couldSaveAddressBook = ABAddressBookSave(paramAddressBook, 
                                                 &couldSaveAddressBookError);
        if (couldSaveAddressBook){
          NSLog(@"Udało się zapisać zmiany w książce adresowej.");
        } else {
          CFRelease(result);
          result = NULL;
          NSLog(@"Nie udało się zapisać zmian w książce adresowej.");
        }
      } else {
        CFRelease(result);
        result = NULL;
        NSLog(@"Brak niezapisanych zmian.");
      }
    } else {
      CFRelease(result);
      result = NULL;
      NSLog(@"Nie udało się dodać nowej grupy.");
    }
  } else {
    CFRelease(result);
    result = NULL;
    NSLog(@"Nie udało się przypisać nazwy grupie.");
  }
  
  return result;
  
}


- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  ABAddressBookRef addressBook = ABAddressBookCreate();
  
  if (addressBook != nil){
    NSLog(@"Udało się uzyskać dostęp do książki adresowej.");
    
    ABRecordRef personalCoachesGroup =
    [self newGroupWithName:@"Trenerzy"
             inAddressBook:addressBook];
    
    if (personalCoachesGroup != NULL){
      NSLog(@"Udało się utworzyć grupę.");
      CFRelease(personalCoachesGroup);
    } else {
      NSLog(@"Nie udało się utworzyć grupy.");
    }
    
    CFRelease(addressBook);
    
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
